**Description of content**
Predicted concentrations and half-widths for the Desert Tortoise trials and the FLADIS
trials are stored in csv-format and located in the folders named "Desert_Tortoise" and 
"FLADIS", respectively.

The concentrations are given as molar concentrations in ppm, and calculated from the 
sum of liquid NH3 and vapor NH3.

Half-widths are estimated as the transverse distance where the concentrations reach
exp(-0.5) multiplied by the center-value.

The values are extracted at the sensor heights. This means that in the Desert Tortoise
trials, values are extracted along the height of 1 m, and in the FLADIS trials, values
are extracted at heights of 0.1 m, 0.5 m and 1.5 m at distances 20 m, 70 m and 240 m,
respectively.

As our model is developed with special focus on an accurate description of how ammonia
interacts with air humidity, we have included a sensitivity test on humidity for the
DT2 trial. Concentration versus distance at 0 % relative humidity and 99.5 % relative 
humidity are given in the folder named "EXTRA", under the names "DT2_0RH_concentration.csv"
and "DT2_99.5RH_concentration.csv", respectively.

Plots comparing the predictions and modelling results are found in the folder
"EXTRA", together with the plot comparing results with different humidities on
DT2.

**Short Description of model**
Name: NH3Foam

The model is based on the rhoReactingBuoyantFoam solver in OpenFOAM v2206, but with
added thermodynamic functionality to include binary phase change of water and ammonia,
including the interactions between them.

The atmospheric stability class is left as neutral (D) for all trials. We used the 
standard k-epsilon model for turbulence with turbulent Schmidt number 0.7.
